export default function NextPageDisallowReExportAllExports() {
    return {
        visitor: {
            ExportAllDeclaration (path) {
                var ref, ref1;
                const err = new SyntaxError(`Using \`export * from '...'\` in a page is disallowed. Please use \`export { default } from '...'\` instead.\n` + `Read more: https://nextjs.org/docs/messages/export-all-in-page`);
                err.code = "BABEL_PARSE_ERROR";
                err.loc = (((ref = path.node.loc) == null ? void 0 : ref.start) ?? ((ref1 = path.node.loc) == null ? void 0 : ref1.end)) ?? path.node.loc;
                throw err;
            }
        }
    };
};

//# sourceMappingURL=next-page-disallow-re-export-all-exports.js.map